package jamezo97.clonecraft.entity.clone.AI;

import jamezo97.clonecraft.entity.clone.EntityClone;
import jamezo97.clonecraft.network.Handler14OnEatenFood;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.CloneCraftItemAccessor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class EntityAICloneEat extends EntityAIBase {

	EntityClone clone;

	public EntityAICloneEat(EntityClone clone){
		this.clone = clone;
	}

	int stackSlot = -1;
	
	ItemStack stackToEat = null;

	@Override
	public boolean shouldExecute() {
		if(clone.foodStats.needFood()){
			stackToEat = null;
			int emptySlot = -1;
			for(int a = 0; a < 9; a++){
				ItemStack itemstack = clone.inventory.mainInventory[a];
				if(itemstack != null){
					Item item = itemstack.getItem();
					if(item instanceof ItemFood){
						stackToEat = itemstack;
						stackSlot = a;
					}
				}else{
					emptySlot = a;
				}
			}
			if(stackToEat == null && emptySlot > -1){
				for(int a = 9; a < clone.inventory.mainInventory.length; a++){
					ItemStack itemstack = clone.inventory.mainInventory[a];
					if(itemstack != null){
						Item item = itemstack.getItem();
						if(item instanceof ItemFood){
							clone.inventory.swapItems(a, emptySlot);
							stackToEat = itemstack;
							stackSlot = emptySlot;
							break;
						}
					}
				}
			}
			return stackToEat != null;
		}
		return false;
	}
	
	

	@Override
	public void startExecuting() {
		clone.inventory.currentItem = stackSlot;
		clone.setItemInUse(stackToEat, stackToEat.getItem().getMaxItemUseDuration(stackToEat));
	}

	public boolean isInterruptible()
    {
        return false;
    }

	@Override
	public void resetTask() {
//		System.out.println("Finished");
	}

	public boolean continueExecuting() {
		return clone.isUsingItem();
	}





}
